using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using FKAttendOCXCSSample;

public class GlobalConstants
{
	public frmMain gfrmMain;
	public const string  gstrNoDevice = "No Device";
	public const short MAX_BELLCOUNT_DAY = 24;
	public const short MAX_PASSCTRLGROUP_COUNT= 50;
	public const short MAX_PASSCTRL_COUNT = 7;
	public const short MAX_USERPASSINFO_COUNT = 3;
	public const short MAX_GROUPPASSINFO_COUNT = 3;
	public const short MAX_GROUPMATCHINFO_COUNT = 10;
}

//******************************************************************/
//*                            Structure                           */
//******************************************************************/

struct BELLINFO
{
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_BELLCOUNT_DAY )]
	public byte[] mValid;
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_BELLCOUNT_DAY )]
	public byte[] mHour;
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_BELLCOUNT_DAY )]
	public byte[] mMinute;
};//72byte


//--- Pass Control Time ---
struct PASSTIME
{
	public 	byte StartHour;
	public 	byte StartMinute;
	public 	byte EndHour;
	public 	byte EndMinute;
};//4byte

//--- Pass Control Time Infomation ---
struct PASSCTRLTIME
{
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_PASSCTRL_COUNT )]
	public PASSTIME[] mPassCtrlTime;
};
//28byte


struct USERPASSINFO
{
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_USERPASSINFO_COUNT )]
	public byte[] UserPassID;
};
//3byte

struct GROUPPASSINFO
{
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_GROUPPASSINFO_COUNT )]
	public byte[] GroupPassID;
};
//3byte


struct GROUPMATCHINFO
{
	[ MarshalAs( UnmanagedType.ByValArray, SizeConst=GlobalConstants.MAX_GROUPMATCHINFO_COUNT)]
	public short[] GroupMatch;
};
//20byte

//=============== USBModel Kind  ===============//
public enum enumUSBModelKind
{
	FK625_FP1000 = 2001,
	FK625_FP2000 = 2002,
	FK625_FP3000 = 2003,
	FK625_FP5000 = 2004,
	FK625_FP10000 = 2005,
	FK625_FP30000 = 2006,
	FK625_ID30000 = 2007,
	FK635_FP700 = 3001,
	FK635_FP3000 = 3002,
	FK635_FP10000 = 3003,
	FK635_ID30000 = 3004,
	FK723_FP1000 = 4001,
	FK725_FP1000 = 5001,
	FK725_FP1500 = 5002,
	FK725_ID5000 = 5003,
	FK725_ID30000 = 5004,
	FK735_FP500 = 6001,
	FK735_FP3000 = 6002,
	FK735_ID30000 = 6003,
	FK925_FP3000 = 7001,
	FK935_FP3000 = 8001,
};
//=============== Protocol Type ===============//
public enum enumProtocolType
{
	PROTOCOL_TCPIP = 0,               // TCP/IP
	PROTOCOL_UDP = 1,                  // UDP
};

//=============== Backup Number Constant ===============//
public enum enumBackupNumberType
{
	BACKUP_FP_0 = 0,                   // Finger 0
	BACKUP_FP_1 = 1,                   // Finger 1
	BACKUP_FP_2 = 2,                   // Finger 2
	BACKUP_FP_3 = 3,                   // Finger 3
	BACKUP_FP_4 = 4,                   // Finger 4
	BACKUP_FP_5 = 5,                   // Finger 5
	BACKUP_FP_6 = 6,                   // Finger 6
	BACKUP_FP_7 = 7,                   // Finger 7
	BACKUP_FP_8 = 8,                   // Finger 8
	BACKUP_FP_9 = 9,                   // Finger 9
	BACKUP_PSW = 10,                   // Password
	BACKUP_CARD = 11,                  // Card
};
//=============== Manipulation of SuperLogData ===============//
public enum enumSuperLogInfo
{
	LOG_ENROLL_USER = 3,               // Enroll-User
	LOG_ENROLL_MANAGER = 4,            // Enroll-Manager
	LOG_ENROLL_DELFP = 5,              // FP Delete
	LOG_ENROLL_DELPASS = 6,            // Pass Delete
	LOG_ENROLL_DELCARD = 7,            // Card Delete
	LOG_LOG_ALLDEL = 8,                // LogAll Delete
	LOG_SETUP_SYS = 9,                 // Setup Sys
	LOG_SETUP_TIME = 10,               // Setup Time
	LOG_SETUP_LOG = 11,                // Setup Log
	LOG_SETUP_COMM = 12,               // Setup Comm
	LOG_PASSTIME = 13,                 // Pass Time Set
	LOG_SETUP_DOOR = 14,               // Door Set Log
};
//=============== VerifyMode of GeneralLogData ===============//
public enum enumGLogVerifyMode
{
	LOG_FPVERIFY = 1,                 // Fp Verify
	LOG_PASSVERIFY = 2,               // Pass Verify
	LOG_CARDVERIFY = 3,               // Card Verify
	LOG_FPPASS_VERIFY = 4,            // Pass+Fp Verify
	LOG_FPCARD_VERIFY = 5,            // Card+Fp Verify
	LOG_PASSFP_VERIFY = 6,            // Pass+Fp Verify
	LOG_CARDFP_VERIFY = 7,            // Card+Fp Verify
	LOG_JOB_NO_VERIFY = 8,            // Job number Verify
	LOG_CARDPASS_VERIFY = 9,          // Card+Pass Verify
	LOG_CLOSE_DOOR = 10,              // Door Close
	LOG_OPEN_HAND = 11,               // Hand Open
	LOG_PROG_OPEN = 12,               // Open by PC
	LOG_PROG_CLOSE = 13,              // Close by PC
	LOG_OPEN_IREGAL = 14,             // Iregal Open
	LOG_CLOSE_IREGAL = 15,            // Iregal Close
	LOG_OPEN_COVER = 16,              // Cover Open
	LOG_CLOSE_COVER = 17,             // Cover Close

	LOG_OPEN_DOOR = 32,               // Door Open
	LOG_OPEN_THREAT = 48,             // Door Open as threat
};
//=============== IOMode of GeneralLogData ===============//
public enum enumGLogIOMode
{
	LOG_MODE_IO = 0,  // General
	LOG_MODE_IN1 = 1, // IN1
	LOG_MODE_IN2 = 2, // IN2
	LOG_MODE_IN3 = 3, // IN3
	LOG_MODE_OUT1 = 4, // OUT1
	LOG_MODE_OUT2 = 5, // OUT2
	LOG_MODE_OUT3 = 6, // OUT3
};
//=============== Machine Privilege ===============//
public enum enumMachinePrivilege
{
	MP_NONE = 0,                       // General user
	MP_ALL = 1,                        // Manager
};
//=============== Index of  GetDeviceStatus ===============//
public enum enumGetDeviceStatus
{
	GET_MANAGERS = 1,
	GET_USERS = 2,
	GET_FPS = 3,
	GET_PSWS = 4,
	GET_SLOGS = 5,
	GET_GLOGS = 6,
	GET_ASLOGS = 7,
	GET_AGLOGS = 8,
	GET_CARDS = 9,
};
//=============== Index of  GetDeviceInfo ===============//
public enum enumGetDeviceInfo
{
	DI_MANAGERS = 1,                   // Numbers of Manager
	DI_MACHINENUM = 2,                 // Device ID
	DI_LANGAUGE = 3,                   // Language
	DI_POWEROFF_TIME = 4,              // Auto-PowerOff Time
	DI_LOCK_CTRL = 5,                  // Lock Control
	DI_GLOG_WARNING = 6,               // General-Log Warning
	DI_SLOG_WARNING = 7,               // Super-Log Warning
	DI_VERIFY_INTERVALS = 8,           // Verify Interval Time
	DI_RSCOM_BPS = 9,                  // Comm Buadrate
	DI_DATE_SEPARATE = 10,             // Date Separate Symbol
	DI_VERIFY_KIND = 24,               // Verify Kind Symbol
};
//=============== Baudrate = value of DI_RSCOM_BPS ===============//
public enum enumBaudrate
{
	BPS_9600 = 3,
	BPS_19200 = 4,
	BPS_38400 = 5,
	BPS_57600 = 6,
	BPS_115200 = 7,
};
//=============== Product Data Index ===============//
public enum enumProductInfo
{
	PRODUCT_SERIALNUMBER = 1,     // Serial Number
	PRODUCT_BACKUPNUMBER = 2,     // Backup Number
	PRODUCT_CODE = 3,             // Product code
	PRODUCT_NAME = 4,             // Product name
	PRODUCT_WEB = 5,              // Product web
	PRODUCT_DATE = 6,             // Product date
	PRODUCT_SENDTO = 7,           // Product sendto
};
//=============== Door Status ===============//
public enum enumDoorStatus
{
	DOOR_CONROLRESET = 0,
	DOOR_OPEND = 1,
	DOOR_CLOSED = 2,
	DOOR_COMMNAD = 3,
};
//=============== Error code ===============//
public enum enumErrorCode
{
	RUN_SUCCESS = 1,
	RUNERR_NOSUPPORT = 0,
	RUNERR_UNKNOWNERROR = -1,
	RUNERR_NO_OPEN_COMM = -2,
	RUNERR_WRITE_FAIL = -3,
	RUNERR_READ_FAIL = -4,
	RUNERR_INVALID_PARAM = -5,
	RUNERR_NON_CARRYOUT = -6,
	RUNERR_DATAARRAY_END = -7,
	RUNERR_DATAARRAY_NONE = -8,
	RUNERR_MEMORY = -9,
	RUNERR_MIS_PASSWORD = -10,
	RUNERR_MEMORYOVER = -11,
	RUNERR_DATADOUBLE = -12,
	RUNERR_MANAGEROVER = -14,
	RUNERR_FPDATAVERSION = -15,
};

